// Topic 4: Function overriding using pointers to the base class types

#include <stdio.h>

class Base
{
	public:
		void Foo() { printf("BASE!\n"); }

	protected:
};

class Child : public Base
{
	public:
		Child() { m_value = 50; }

		void Foo() { printf("CHILD!\n"); }

		void Bar() { printf("Value: %d\n", m_value); }

	private:
		int m_value;
};

void main()
{
	Base* pBase1 = new Base;
	Base* pBase2 = new Child;

	pBase1->Foo();	// Will run Base version
	pBase2->Foo();	// Will ALSO run Base version!

	// You cannot call the child function through the base directly
/*	pBase2->Child::Foo(); */

	// Clean up
	delete pBase1;
	delete pBase2;
}